#include <p30fxxxx.h>
#include <incap.h>

/* These devices support Input Capture 3 thru Input Capture 6 */
#if defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__) || \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__)

/********************************************************************
*    Function Name:  ReadCapture3                                   *
*    Description:    This routine reads all pending InputCapture    *
*                    Buffers and stores in the locations specified  *
*    Parameters:     address of locations where buffer data to be   *
*                    stored                                         *
*    Return Value:   None                                           *
********************************************************************/

void ReadCapture3(unsigned int * buffer)
{
	while (IC3CONbits.ICBNE)
	{
		*buffer++ = IC3BUF; /* reads the input capture buffer */
	}
}

#endif 
